VERSION 5.00
Begin VB.Form fPDFViewer 
   Caption         =   "Visualizing with a dynamically loaded Acrobat-PDF-COMponent"
   ClientHeight    =   12180
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   7200
   LinkTopic       =   "Form1"
   ScaleHeight     =   12180
   ScaleWidth      =   7200
End
Attribute VB_Name = "fPDFViewer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function ShellExecuteW Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As Long, ByVal lpFile As Long, _
                                                          ByVal lpParameters As Long, ByVal lpDirectory As Long, ByVal nShowCmd As Long) As Long

Private PDFExt As VBControlExtender, PDF As Object

Public Sub LoadPDF(Optional FileName As String)
  RemovePDF 'first we destroy the current Document- *and* Control-Instance (if there is one), since this seems to be the only way to not leak Handles with the Acrobat-Control
  
  If Len(FileName) = 0 Then Exit Sub
  
  'A "cascading attempt", to load one of the different possible Acrobat-Viewer-COMponents dynamically into a VB-Form ...
  '(this should not take very long, even when we re-instantiate the Control for each new loaded Document)
  On Error Resume Next
    Set PDFExt = Controls.Add("AcroPDF.PDF.1", "PDF") 'for versions 7 and 8
    If PDFExt Is Nothing Then
      Set PDFExt = Controls.Add("PDF.PdfCtrl.6", "PDF")
      If PDFExt Is Nothing Then
        Set PDFExt = Controls.Add("PDF.PdfCtrl.5", "PDF")
        If PDFExt Is Nothing Then
          Set PDFExt = Controls.Add("PDF.PdfCtrl.1", "PDF")
          If PDFExt Is Nothing Then
            If MsgBox("PDF-OCX not found! (or not loadable per Controls.Add, if VB5 is used)" & vbCrLf & _
              "Please install either Acrobat Reader - or allow me, to shell your currently installed PDF-ViewerApp." & vbCrLf & vbCrLf & _
              "May I shell the currently installed PDF-Application on your system?", vbYesNo) = vbYes Then
              ShellExecuteW Me.hWnd, StrPtr("OPEN"), StrPtr(FileName), 0, 0, 0
            End If
            Exit Sub
          End If
        End If
      End If
    End If
    PDFExt.Visible = True
    PDFExt.Move 0, 0, ScaleWidth, ScaleHeight
    
    Set PDF = PDFExt.object
    PDF.LoadFile FileName
    If Me.Visible = False Then Me.Visible = True
  Err.Clear
End Sub

Public Sub RemovePDF()
  If PDF Is Nothing Then Exit Sub
  
  Set PDF = Nothing
  Set PDFExt = Nothing
  Controls.Remove "PDF"
End Sub

Private Sub Form_Load()
  Move Screen.Width - Me.Width, 0
  Me.Show , fCairoDemo 'here we just "declare" the Show-Mode (on top of our fCairoDemo-PreviewForm)...
  Me.Hide '... but hide ourself instantly after that (no PDF-Control is loaded at this point in time, just the "naked Form")
End Sub

Private Sub Form_Resize()
  If Not PDFExt Is Nothing Then PDFExt.Move 0, 0, ScaleWidth, ScaleHeight
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
  If UnloadMode Then Exit Sub 'ensure standard-behaviour
  
  Cancel = True
  Me.Hide '...and in case the Unload-Request came from our own Form we just hide (to keep up our current Screen-position)
End Sub

Private Sub Form_Unload(Cancel As Integer)
  RemovePDF
End Sub

